<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('outlet_id')->references('id')->on('outlets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stores', function(Blueprint $table) {
			$table->foreign('business_categorie_id')->references('id')->on('business_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stores', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stores', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('monthly_bills', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('monthly_bills', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('business_categories', function(Blueprint $table) {
			$table->foreign('business_type_id')->references('id')->on('business_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('outlets', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_categories', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('product_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('outlet_id')->references('id')->on('outlets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('variant_types', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_variants', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_variants', function(Blueprint $table) {
			$table->foreign('outlet_id')->references('id')->on('outlets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_variants', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_variants', function(Blueprint $table) {
			$table->foreign('variant_type_id')->references('id')->on('variant_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stock_transactions', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stock_transactions', function(Blueprint $table) {
			$table->foreign('outlet_id')->references('id')->on('outlets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stock_transactions', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stock_transactions', function(Blueprint $table) {
			$table->foreign('variant_id')->references('id')->on('variant_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('kasir_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('variant_id')->references('id')->on('product_variants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_profile_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_store_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_outlet_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_role_id_foreign');
		});
		Schema::table('stores', function(Blueprint $table) {
			$table->dropForeign('stores_business_categorie_id_foreign');
		});
		Schema::table('stores', function(Blueprint $table) {
			$table->dropForeign('stores_user_id_foreign');
		});
		Schema::table('stores', function(Blueprint $table) {
			$table->dropForeign('stores_service_id_foreign');
		});
		Schema::table('monthly_bills', function(Blueprint $table) {
			$table->dropForeign('monthly_bills_store_id_foreign');
		});
		Schema::table('monthly_bills', function(Blueprint $table) {
			$table->dropForeign('monthly_bills_service_id_foreign');
		});
		Schema::table('business_categories', function(Blueprint $table) {
			$table->dropForeign('business_categories_business_type_id_foreign');
		});
		Schema::table('outlets', function(Blueprint $table) {
			$table->dropForeign('outlets_store_id_foreign');
		});
		Schema::table('product_categories', function(Blueprint $table) {
			$table->dropForeign('product_categories_store_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_category_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_store_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_outlet_id_foreign');
		});
		Schema::table('variant_types', function(Blueprint $table) {
			$table->dropForeign('variant_types_store_id_foreign');
		});
		Schema::table('product_variants', function(Blueprint $table) {
			$table->dropForeign('product_variants_store_id_foreign');
		});
		Schema::table('product_variants', function(Blueprint $table) {
			$table->dropForeign('product_variants_outlet_id_foreign');
		});
		Schema::table('product_variants', function(Blueprint $table) {
			$table->dropForeign('product_variants_product_id_foreign');
		});
		Schema::table('product_variants', function(Blueprint $table) {
			$table->dropForeign('product_variants_variant_type_id_foreign');
		});
		Schema::table('stock_transactions', function(Blueprint $table) {
			$table->dropForeign('stock_transactions_store_id_foreign');
		});
		Schema::table('stock_transactions', function(Blueprint $table) {
			$table->dropForeign('stock_transactions_outlet_id_foreign');
		});
		Schema::table('stock_transactions', function(Blueprint $table) {
			$table->dropForeign('stock_transactions_product_id_foreign');
		});
		Schema::table('stock_transactions', function(Blueprint $table) {
			$table->dropForeign('stock_transactions_variant_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_kasir_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_order_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_product_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_variant_id_foreign');
		});
	}
}