<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeesTable extends Migration {

	public function up()
	{
		Schema::create('employees', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('profile_id')->unsigned();
			$table->integer('store_id')->unsigned();
			$table->integer('outlet_id')->unsigned()->nullable();
			$table->integer('role_id')->unsigned();
			$table->boolean('is_active')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('employees');
	}
}