<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('order_code')->unique();
			$table->datetime('transaction_time');
			$table->integer('kasir_id')->unsigned();
			$table->integer('total_item');
			$table->integer('total_price');
			$table->decimal('discount');
			$table->decimal('ppn');
			$table->decimal('final_amount');
			$table->string('payment_method');
			$table->enum('status', array('pending', 'paid', 'cancelled'));
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}