<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOutletsTable extends Migration {

	public function up()
	{
		Schema::create('outlets', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('store_id')->unsigned();
			$table->string('name');
			$table->string('address');
			$table->string('phone');
			$table->boolean('is_active')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('outlets');
	}
}