<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoresTable extends Migration {

	public function up()
	{
		Schema::create('stores', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('description')->nullable();
			$table->integer('business_categorie_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->integer('service_id')->unsigned();
			$table->string('address');
			$table->string('city');
			$table->string('province');
			$table->string('postal_code');
			$table->string('logo');
			$table->boolean('is_ppn')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('stores');
	}
}