<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductVariantsTable extends Migration {

	public function up()
	{
		Schema::create('product_variants', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('store_id')->unsigned()->nullable();
			$table->integer('outlet_id')->unsigned()->nullable();
			$table->integer('product_id')->unsigned();
			$table->integer('variant_type_id')->unsigned();
			$table->string('name');
			$table->decimal('extra_price')->default('0');
			$table->integer('stock')->default('0');
			$table->boolean('is_active')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('product_variants');
	}
}