<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('description')->nullable();
			$table->integer('price');
			$table->integer('duration_days');
			$table->boolean('is_active')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}