<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Buyer extends Model 
{

    protected $table = 'buyers';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'mobile', 'district_id', 'address', 'password');

    public function review()
    {
        return $this->hasMany('App\Review');
    }

    public function order()
    {
        return $this->hasMany('App\Order');
    }

    public function district()
    {
        return $this->hasOne('App\District');
    }

    public function notifiable()
    {
        return $this->morphMany('App\Notifcation');
    }

}