<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;
    protected $fillable = array('buyer_id', 'seller_id', 'status', 'cost', 'delivery_cost', 'total', 'commission', 'notes');

    public function product()
    {
        return $this->hasMany('App\Product');
    }

    public function buyer()
    {
        return $this->belongsTo('App\Buyer');
    }

    public function seller()
    {
        return $this->belongsTo('App\Seller');
    }

}