<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('seller_id')->unsigned();
			$table->string('name');
			$table->text('description');
			$table->decimal('price');
			$table->datetime('from');
			$table->datetime('to');
			$table->string('image');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}