<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSellersTable extends Migration {

	public function up()
	{
		Schema::create('sellers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('shop_name');
			$table->integer('district_id')->unsigned();
			$table->string('email', 150)->unique();
			$table->string('password');
			$table->decimal('min_charge');
			$table->decimal('delivery_cost');
			$table->string('mobile', 25)->unique();
			$table->string('whatsapp', 25)->unique();
			$table->string('image');
			$table->boolean('is_on')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('sellers');
	}
}