<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Member extends Model 
{

    protected $table = 'members';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function plan()
    {
        return $this->belongsTo('App\Plan', 'plan_id');
    }

    public function feesTransactions()
    {
        return $this->hasMany('App\MemberFeesTransaction', 'member_id');
    }

    public function smsLists()
    {
        return $this->hasMany('App\SendSMS', 'member_id');
    }

}