<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMemberFeesTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('member_fees_transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->default('0');
			$table->bigInteger('member_id')->default('0');
			$table->decimal('amount', 10,2)->default('0');
			$table->string('description', 255)->nullable();
			$table->integer('transaction_type')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('member_fees_transactions');
	}
}