<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMembersTable extends Migration {

	public function up()
	{
		Schema::create('members', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('name', 255);
			$table->string('serial_no', 100);
			$table->date('date')->nullable();
			$table->integer('gender')->default('0');
			$table->integer('age')->default('0');
			$table->string('mobile', 50)->nullable();
			$table->boolean('marital_status')->default(0);
			$table->text('address')->nullable();
			$table->integer('monthly_plan')->default('0');
			$table->integer('plan_id')->default('0');
			$table->integer('goal')->default('0');
			$table->string('height', 50)->nullable();
			$table->string('weight', 50)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('members');
	}
}