<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMemberInfoTable extends Migration {

	public function up()
	{
		Schema::create('MemberInfo', function(Blueprint $table) {
			$table->increments('MemberID');
			$table->integer('MemberHouseholdID')->unsigned();
			$table->integer('MemberTypeID')->unsigned();
			$table->string('LoginEmail')->unique();
			$table->string('LoginSecret');
			$table->boolean('LoginSecretExpired');
			$table->string('FirstName', 50);
			$table->string('MiddleName', 50);
			$table->string('LastName', 60);
			$table->string('MailingAddress1', 80);
			$table->string('MailingAddress2', 80);
			$table->string('MailingAddress3', 80);
			$table->string('MailingCity', 40);
			$table->string('MailingStateABR', 2);
			$table->string('MailingZipRoot', 10);
			$table->smallInteger('MailingZipPlus4');
			$table->string('MailingAddressCountry')->default('USA');
			$table->string('HomeAddress1', 80);
			$table->string('HomeAddress2', 80);
			$table->string('HomeAddress3', 80);
			$table->string('HomeCity', 40);
			$table->string('HomeStateABR', 2);
			$table->string('HomeZipRoot', 10);
			$table->string('HomeAddressCountry');
			$table->date('DOB');
			$table->integer('HomePhone');
			$table->integer('WorkPhone');
			$table->integer('CellPhone');
			$table->boolean('IsCellPhoneSMSCapable');
			$table->string('Email2', 80);
			$table->string('Comments', 300);
			$table->date('MembershipRenewalDate');
			$table->date('MembershipExpirationDate');
			$table->datetime('ModificationData');
		});
	}

	public function down()
	{
		Schema::drop('MemberInfo');
	}
}