<?php

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	public function messages()
	{
		return $this->hasMany('Message', 'user_id');
	}

	public function profile()
	{
		return $this->hasOne('Profile', 'user_id');
	}

	public function staus()
	{
		return $this->hasMany('UserStatus', 'user_id');
	}

	public function user_devices()
	{
		return $this->hasMany('Device', 'user_id');
	}

	public function user_chats()
	{
		return $this->hasMany('Chat', 'user_id');
	}

	public function user_groups()
	{
		return $this->hasMany('Group', 'user_id');
	}

}