<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('books', function(Blueprint $table) {
			$table->foreign('author_id')->references('author_id')->on('books')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('authors', function(Blueprint $table) {
			$table->foreign('company_id')->references('company_id')->on('authors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('books', function(Blueprint $table) {
			$table->dropForeign('books_author_id_foreign');
		});
		Schema::table('authors', function(Blueprint $table) {
			$table->dropForeign('authors_company_id_foreign');
		});
	}
}