<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Adresses extends Eloquent {

	protected $table = 'addresses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('costumer_id', 'address', 'city_id');
	protected $visible = array('costumer_id', 'address', 'city_id');

	public function costumer()
	{
		return $this->belongsTo('App\Entities\Costumer');
	}

	public function city()
	{
		return $this->belongsTo('App\Entities\City');
	}

}