<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Company extends Eloquent {

	protected $table = 'companies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'address', 'city_id', 'owner', 'phone');
	protected $visible = array('name', 'address', 'city_id', 'owner', 'phone');

	public function city()
	{
		return $this->belongsTo('App\Entities\City');
	}

	public function products()
	{
		return $this->hasMany('App\Entities\Product');
	}

	public function users()
	{
		return $this->morphMany('App\Entities\User');
	}

}