<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Deliver extends Eloquent {

	protected $table = 'delivers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('sale_id', 'costumer_id', 'address_id', 'deliver_at');
	protected $visible = array('sale_id', 'costumer_id', 'address_id', 'deliver_at');

	public function address()
	{
		return $this->hasOne('App\Entities\Adresses');
	}

}