<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'category_id', 'description', 'status', 'value', 'unit', 'total', 'company_id', 'user_id');
	protected $visible = array('name', 'category_id', 'description', 'status', 'value', 'unit', 'total', 'company_id', 'user_id');

	public function company()
	{
		return $this->belongsTo('App\Entities\Company');
	}

	public function category()
	{
		return $this->belongsTo('App\Entities\Category');
	}

	public function sales()
	{
		return $this->belongsToMany('App\Entities\Sale')->withPrivot('products_sales');
	}

	public function user()
	{
		return $this->belongsTo('App\Entities\User');
	}

}