<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100);
			$table->integer('category_id')->unsigned();
			$table->text('description')->nullable();
			$table->tinyInteger('status');
			$table->integer('value');
			$table->string('unit', 50)->unique();
			$table->integer('total');
			$table->integer('company_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}