<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username', 50);
			$table->string('email', 50)->unique();
			$table->integer('company_id')->unsigned();
			$table->integer('costumer_id')->unsigned();
			$table->string('password', 255);
			$table->rememberToken('rememberToken');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}