<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('userid');
			$table->datetime('orderdate');
			$table->integer('ordertype');
			$table->decimal('subtotal', 14,4);
			$table->decimal('tax', 14,4);
			$table->decimal('shipping', 14,4);
			$table->decimal('total', 14,4);
			$table->string('promocode', 30);
			$table->decimal('discount', 14,4);
			$table->decimal('grandtotal', 14,4);
			$table->integer('addressid');
			$table->integer('totalitems');
			$table->integer('outletid');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}