<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePermissionsTable extends Migration {

	public function up()
	{
		Schema::create('permissions', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 100)->unique();
			$table->string('description', 255)->nullable();
			$table->string('slug', 100)->unique();
		});
	}

	public function down()
	{
		Schema::drop('permissions');
	}
}