<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BlogPlatformRequirement extends Model 
{

    protected $table = 'blog_platform_requirement';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('platform_requirement_id', 'blog_id', 'value');

    public function platform_requirement()
    {
        return $this->belongsTo('PlatformRequirement', 'platform_requirement_id');
    }

    public function blog()
    {
        return $this->belongsTo('Blog', 'blog_id');
    }

}