<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PlatformRequirement extends Model 
{

    protected $table = 'platform_requirement';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('platform_id', 'name', 'title', 'type');

    public function platform()
    {
        return $this->belongsTo('Platform', 'plarform_id');
    }

}