<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Shortcut extends Model 
{

    protected $table = 'shortcut';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'link', 'user_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}