<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Blog extends Eloquent {

	protected $table = 'blog';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'platform_id', 'link', 'title', 'favicon');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function plarform()
	{
		return $this->belongsTo('Platform', 'platform_id');
	}

	public function requirements()
	{
		return $this->belongsToMany('PlatformRequirement', 'blog_id', 'platform_requirement_id', 'blog_platform_requirement');
	}

}