<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'category';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('blog_id', 'name', 'user_id');

	public function blog()
	{
		return $this->belongsTo('Blog', 'blog_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}