<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PlatformRequirement extends Eloquent {

	protected $table = 'platform_requirement';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('platform_id', 'name', 'title', 'type');

	public function platform()
	{
		return $this->belongsTo('Platform', 'plarform_id');
	}

}