<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PostTag extends Eloquent {

	protected $table = 'post_tag';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('post_id', 'tag_id');

	public function post()
	{
		return $this->belongsTo('Post', 'post_id');
	}

	public function tag()
	{
		return $this->belongsTo('Tag', 'tag_id');
	}

}