<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlatformRequirementTable extends Migration {

	public function up()
	{
		Schema::create('platform_requirement', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('platform_id')->nullable();
			$table->string('name')->nullable();
			$table->string('title')->nullable();
			$table->enum('type', array('input', 'textarea'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('platform_requirement');
	}
}