<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostTable extends Migration {

	public function up()
	{
		Schema::create('post', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title')->nullable();
			$table->text('details')->nullable();
			$table->integer('category_id')->nullable();
			$table->integer('blog_id')->nullable();
			$table->integer('user_id')->nullable();
			$table->string('meta_title')->nullable();
			$table->text('meta_description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('post');
	}
}