<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Target extends Model 
{

    protected $table = 'targets';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function targetType()
    {
        return $this->belongsTo('TargetType');
    }

    public function targetable()
    {
        return $this->morphTo();
    }

    public function progressLogs()
    {
        return $this->hasMany('TargetProgressLogs');
    }

    public function assignments()
    {
        return $this->hasMany('TargetAssignments');
    }

}