<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TargetAssignments extends Model 
{

    protected $table = 'target_assignments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function assignable()
    {
        return $this->morphTo();
    }

    public function target()
    {
        return $this->belongsTo('Target');
    }

    public function progressLogs()
    {
        return $this->hasMany('TargetProgressLogs');
    }

}