<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTargetProgressLogsTable extends Migration {

	public function up()
	{
		Schema::create('target_progress_logs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('target_id')->unsigned();
			$table->decimal('added_value');
			$table->decimal('value_before');
			$table->decimal('value_after');
			$table->boolean('is_approved');
			$table->text('rejection_reason')->nullable();
			$table->date('effective_date');
			$table->boolean('needs_approval');
			$table->integer('approved_by')->unsigned();
			$table->timestamp('approved_at');
			$table->string('progressable_type');
			$table->string('progressable_id');
		});
	}

	public function down()
	{
		Schema::drop('target_progress_logs');
	}
}