<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Target extends Eloquent {

	protected $table = 'targets';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function targetType()
	{
		return $this->belongsTo('TargetType');
	}

	public function targetable()
	{
		return $this->morphTo();
	}

	public function progressLogs()
	{
		return $this->hasMany('TargetProgressLogs');
	}

	public function assignments()
	{
		return $this->hasMany('TargetAssignments');
	}

}