<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->string('image');
			$table->text('description');
			$table->increments('price');
			$table->timestamps();
			$table->bigInteger('teacher_id')->unsigned();
			$table->bigInteger('category_id')->unsigned();
			$table->bigInteger('duration_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}