<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class League extends Model 
{

    protected $table = 'leagues';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'country_code', 'hidden');

    public function games()
    {
        return $this->hasMany('App\Game');
    }

}