<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLeaguesTable extends Migration {

	public function up()
	{
		Schema::create('leagues', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('country_code', 3);
			$table->boolean('hidden')->default(0);
			$table->boolean('modified')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('leagues');
	}
}