<?php

namespace App\Models;

class Company extends Eloquent {

	protected $table = 'companies';
	public $timestamps = true;

	public function region()
	{
		return $this->belongsTo('Region');
	}

	public function parent()
	{
		return $this->belongsTo('Company');
	}

	public function sector()
	{
		return $this->belongsTo('BusinessLine');
	}

	public function indicators()
	{
		return $this->hasMany('Indicator', 'company_id');
	}

	public function employees()
	{
		return $this->hasMany('Employee', 'company_id');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function branches()
	{
		return $this->hasMany('BusinessBranches', 'company_id');
	}

	public function jobs()
	{
		return $this->hasMany('BusinessJobs', 'company_id');
	}

}