<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventTable extends Migration {

	public function up()
	{
		Schema::create('event', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->integer('typeId');
			$table->integer('categoryId');
			$table->integer('statusId')->unsigned();
			$table->string('location');
			$table->text('description');
			$table->datetime('startDatetime');
			$table->date('periodicEndDate');
			$table->time('atMonday');
			$table->time('atTuesday');
			$table->time('atWendesday');
			$table->time('atThursday');
			$table->time('atFriday');
			$table->time('atSaturday');
			$table->time('atSunday');
			$table->date('periodicDeadlineDate');
			$table->integer('ageLimit');
			$table->integer('seatsNumber');
			$table->boolean('isPayment');
			$table->integer('paymentSumm')->nullable();
			$table->boolean('isPeriodic');
			$table->boolean('isConsent');
			$table->boolean('isCreateChat');
			$table->boolean('isSiteDisplay');
			$table->text('comment');
			$table->integer('createdAt');
			$table->integer('updatedAt');
			$table->integer('createdBy')->unsigned();
			$table->integer('updatedBy')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('event');
	}
}