<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOperationDrugsTable extends Migration {

	public function up()
	{
		Schema::create('operation_drugs', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('operation_id')->unsigned();
			$table->integer('drug_id')->unsigned()->nullable();
			$table->integer('drug_strength_id')->unsigned()->nullable();
			$table->integer('drug_type_id')->unsigned()->nullable();
			$table->integer('drug_repeat_id')->unsigned()->nullable();
			$table->string('dose');
			$table->tinyInteger('condition')->nullable();
			$table->date('start_date')->nullable();
			$table->date('end_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('operation_drugs');
	}
}