<?php

namespace App\Models;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	public function user_type()
	{
		return $this->belongsTo('UserType');
	}

	public function doctor()
	{
		return $this->hasOne('Doctor');
	}

	public function patient()
	{
		return $this->hasOne('Patient');
	}

	public function assistant()
	{
		return $this->hasOne('Assistant');
	}

	public function state()
	{
		return $this->belongsTo('State');
	}

	public function city()
	{
		return $this->belongsTo('City');
	}

	public function notifications()
	{
		return $this->hasMany('Notification');
	}

}