<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLookupsTable extends Migration {

	public function up()
	{
		Schema::create('lookups', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('parent_id')->unsigned();
			$table->string('name_en');
			$table->string('name_ar');
			$table->string('slug');
			$table->text('description_en');
			$table->text('description_ar');
			$table->boolean('is_active')->default(true);
			$table->boolean('is_editable')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('lookups');
	}
}