<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackagesTable extends Migration {

	public function up()
	{
		Schema::create('packages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en');
			$table->string('name_ar');
			$table->text('description_en');
			$table->text('description_ar');
			$table->boolean('is_active')->default(false);
			$table->integer('price');
			$table->integer('discount');
			$table->integer('final_price');
			$table->integer('duration');
			$table->integer('ad_limit_per_month');
			$table->boolean('is_recommanded')->default(false);
			$table->tinyInteger('order')->default('0');
			$table->integer('currency_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('packages');
	}
}