<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUnitsTable extends Migration {

	public function up()
	{
		Schema::create('units', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('slug')->unique();
			$table->string('title_en');
			$table->string('title_ar');
			$table->string('meta_title_en');
			$table->string('meta_title_ar');
			$table->longText('description_en');
			$table->longText('description_ar');
			$table->text('meta_descriotion_en');
			$table->text('meta_descriotion_ar');
			$table->integer('price');
			$table->string('down_payment');
			$table->integer('number_of_installments');
			$table->integer('area');
			$table->integer('garden_area');
			$table->integer('plot_area');
			$table->integer('terrace_area');
			$table->integer('roof_area');
			$table->integer('project_id')->unsigned();
			$table->integer('building_number_id')->unsigned();
			$table->integer('position_id')->unsigned();
			$table->integer('view_id')->unsigned();
			$table->integer('bedroom_number_id')->unsigned();
			$table->integer('bathroom_number_id')->unsigned();
			$table->integer('floor_number_id')->unsigned();
			$table->integer('purpose_id')->unsigned();
			$table->integer('purpose_type_id')->unsigned();
			$table->integer('offering_type_id')->unsigned();
			$table->integer('area_unit_id')->unsigned();
			$table->integer('unit_type_id')->unsigned();
			$table->integer('furnishing_status_id')->unsigned();
			$table->integer('fininshing_status_id')->unsigned();
			$table->integer('design_type_id')->unsigned();
			$table->integer('payment_method_id')->unsigned();
			$table->string('views_count');
			$table->boolean('is_featured')->default(true);
			$table->boolean('is_active')->default(true);
			$table->integer('country_id')->unsigned();
			$table->integer('region_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->boolean('seo_index')->default(true);
			$table->string('latitude');
			$table->string('longitude');
			$table->integer('buyer_id')->unsigned();
			$table->integer('currency_id')->unsigned();
			$table->enum('moderation_status', array('new', 'pending', 'approved', 'published', 'rejected'));
		});
	}

	public function down()
	{
		Schema::drop('units');
	}
}