<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('finishing_status_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('developer_id')->references('id')->on('developers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('building_number_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('position_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('view_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('bedroom_number_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('bathroom_number_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('floor_number_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('purpose_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('purpose_type_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('offering_type_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('area_unit_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('unit_type_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('furnishing_status_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('fininshing_status_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('design_type_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('payment_method_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('buyer_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lookups', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('developers', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('developers', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('developers', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('developers', function(Blueprint $table) {
			$table->foreign('developer_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('package_items', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('applicants', function(Blueprint $table) {
			$table->foreign('career_id')->references('id')->on('careers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('testimonials', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('organization_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('organization_user', function(Blueprint $table) {
			$table->foreign('organization_id')->references('id')->on('organization')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('facility_distances', function(Blueprint $table) {
			$table->foreign('lookup_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('comments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('social_posts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('likes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_finishing_status_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_developer_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_country_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_region_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_city_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_currency_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_project_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_building_number_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_position_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_view_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_bedroom_number_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_bathroom_number_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_floor_number_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_purpose_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_purpose_type_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_offering_type_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_area_unit_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_unit_type_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_furnishing_status_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_fininshing_status_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_design_type_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_payment_method_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_country_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_region_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_city_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_buyer_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_currency_id_foreign');
		});
		Schema::table('lookups', function(Blueprint $table) {
			$table->dropForeign('lookups_parent_id_foreign');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->dropForeign('locations_parent_id_foreign');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->dropForeign('packages_currency_id_foreign');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->dropForeign('subscriptions_user_id_foreign');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->dropForeign('subscriptions_package_id_foreign');
		});
		Schema::table('developers', function(Blueprint $table) {
			$table->dropForeign('developers_country_id_foreign');
		});
		Schema::table('developers', function(Blueprint $table) {
			$table->dropForeign('developers_city_id_foreign');
		});
		Schema::table('developers', function(Blueprint $table) {
			$table->dropForeign('developers_region_id_foreign');
		});
		Schema::table('developers', function(Blueprint $table) {
			$table->dropForeign('developers_developer_id_foreign');
		});
		Schema::table('package_items', function(Blueprint $table) {
			$table->dropForeign('package_items_package_id_foreign');
		});
		Schema::table('applicants', function(Blueprint $table) {
			$table->dropForeign('applicants_career_id_foreign');
		});
		Schema::table('testimonials', function(Blueprint $table) {
			$table->dropForeign('testimonials_user_id_foreign');
		});
		Schema::table('organization_user', function(Blueprint $table) {
			$table->dropForeign('organization_user_user_id_foreign');
		});
		Schema::table('organization_user', function(Blueprint $table) {
			$table->dropForeign('organization_user_organization_id_foreign');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->dropForeign('favorites_user_id_foreign');
		});
		Schema::table('facility_distances', function(Blueprint $table) {
			$table->dropForeign('facility_distances_lookup_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_user_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_parent_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_user_id_foreign');
		});
		Schema::table('social_posts', function(Blueprint $table) {
			$table->dropForeign('social_posts_user_id_foreign');
		});
		Schema::table('likes', function(Blueprint $table) {
			$table->dropForeign('likes_user_id_foreign');
		});
	}
}