<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApplicantsTable extends Migration {

	public function up()
	{
		Schema::create('applicants', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('email');
			$table->string('phone_number');
			$table->integer('career_id')->unsigned();
			$table->enum('status', array('Pending', 'Accepted', 'Rejected'));
			$table->enum('gender', array('Male', 'Female'));
		});
	}

	public function down()
	{
		Schema::drop('applicants');
	}
}